## DeepSeek最强专业拆解：清交复教授超硬核解读

导读：DeepSeek的写作能力为何飞跃？PTX是否真正做到了绕开CUDA的垄断？

据2月3日报道，周日晚间，五位高校教授夜话DeepSeek，从模型方法、框架、系统、基础设施等角度，阐述DeepSeek的技术原理与未来方向，揭秘其优化方法如何提升算力能效，信息量很大。

如何复现o1大推理模型？DeepSeek R1技术路线和训练流程有哪些亮点？为什么DeepSeek能做到轰动全球？DeepSeek通过哪些优化策略有效降低成本？DeepSeek的写作能力为何飞跃？MoE架构会是最优解吗？PTX是否真正做到了绕开CUDA的垄断？这些业界关注焦点话题被一一解答。

北京交通大学教授、CCF YOCSEF AC副主席金一主持了这场线上分享。复旦大学教授邱锡鹏，清华大学长聘副教授刘知远，清华大学教授翟季冬，上海交通大学副教授戴国浩，分别从不同专业角度分享了对DeepSeek的思考，并延伸到对中国大模型高质量发展路径的启发。

邱锡鹏教授主持开发了国内首个开源对话式大语言模型MOSS。刘知远教授是大模型创企面壁智能的首席科学家。翟季冬教授是AI基础设施创企清程极智的首席科学家。戴国浩教授是AI基础设施创企无问芯穹的联合创始人。

![img](https://pic.yupi.icu/yuyi/1739504014775-9c7f4e9c-4057-4c18-b7bf-95f7c08155ea.png)

以下是实录整理（为提高阅读体验已做精编）：

## 01 邱锡鹏：解读R1技术路线图，强推理模型最终落脚点是Agent

给大家分享一下关于DeepSeek的一些思考和启发。OpenAI o1也是一个非常现象级的推理模型，在竞赛题目上达到了人类专家水平。OpenAI推出了一个AGI规划，推理在其中是非常重要的一步。

那么在去年Ilya（前OpenAI首席科学家）曾经说过，我们的预训练可能时代可能即将结束了。其中一个非常重要的原因就是数据没有在增长。OpenAI可能会打破这种数据不增长的范式，继续推动Scaling Law向前发展。不过因为没有数据，所以它的目标可能就转向到比如强化学习、推理时计算这种Scaling。推理长度越长，它的性能可以继续得以改进。这使得大家对下一代大模型的发展抱以新期望。

所以我们可以看到o1的各种复现层出不穷。业界非常多的o1复现可能基于比如SFT或者蒸馏的路线。但是其实o1的核心应该还是从RL（强化学习）开始。

我们去年也刚好写了一篇o1的综述。所以我简单以此为概括来看一下o1的四个核心。在强化学习的框架下，大语言模型充当了一个Agent。每个Action是预测Next Token或者Step或者Solution，看不同颗粒度。大模型输入作为State。Policy就是给定当前的步骤或者Talk或者Solution来生成下一阶段的Action。

在强化学习的框架下重新看大推理模型，它有四个重要因素：

一是策略初始化（Policy Initialization），通过预训练、提示工程、监督微调，让模型具有初始的类人推理行为，比如问题理解、任务分解、验证修正错误等。

![img](https://pic.yupi.icu/yuyi/1739504014280-1c738d59-b82e-4724-a270-60eee2a7e443.png)

二是奖励设计（Reward Design），为RL提供奖励信号。传统方法分为两种，一是从环境直接获取奖励信号，二是从专家数据或者偏好数据学习奖励。o1应该是混合了多种奖励设计的方法。比如有groundtruth的环境，将结果监督（ORM）转换为过程监督（PRM）。没有groundtruth的话，就用专家或者偏好数据来学习奖励。在大量领域上训练奖励模型，提升泛化性。

![img](https://pic.yupi.icu/yuyi/1739504014173-28e8fc2d-8463-4584-a65d-779969ef10d4.png)

三是搜索（Search），找寻问题的最优解法。传统方法基本分为两大类，基于树的搜索和基于顺序修改的搜索。这两种可能对复现o1都有非常大的帮助。

![img](https://pic.yupi.icu/yuyi/1739504014379-5808e7f6-ef19-4723-ae6c-17f64d566e86.png)

四是学习（Learning），优化模型参数。基本上就是一个是用强学习的PolicyGradient，还有一个BehaviorCloning。这两种基本上可以用在两个阶段：Warmup阶段可以使用行为克隆方法，快速收敛；第二阶段再用强化学习来提升上限。

![img](https://pic.yupi.icu/yuyi/1739504014372-58769d46-812e-4446-aad6-b92561e3abcb.png)

复现o1大推理模型，基本上都要从这四个方面下功夫。

R1发布有两个模型，一个是R1-Zero。R1-Zero从一个基模型开始，纯RL驱动，经过比如Warmup阶段，它有了一个Reward，让模型具有一个类人回复。比如先给一些prompt，就是要求你的思考要在比如两个Thinking之间，答案要在两个Answer的tag之间，然后用最终结果的正确性和是不是符合这种格式来作为Reward，然后对模型进行奖励。在R1的训练过程中，我们可以看到，随着训练步骤的增加，它逐渐涌现出这种长CoT（思维链）能力，它的推理路径会越来越长。另外它也发现了一些“aha moment”，模型训练过程中能够自我发现，可以尝试修复一些以前的推理。

![img](https://pic.yupi.icu/yuyi/1739504015375-4c0d08a3-0a62-4bf9-8a54-cde3f9da4b9e.png)

在纯强化学习训练中，它的性能可以不断提升。但它有一些不足，它的可读性比较差，还有language mixing（语言混杂）问题，中英文可能会混杂输出。这也是下一步真正的R1要解决的两个问题。

和R1-Zero不同的是，R1模型分为四个阶段来进行。左边这张图是参考了一个知乎问答的路线图，画得非常清楚。

![img](https://pic.yupi.icu/yuyi/1739504015664-c11819c3-a7c0-4410-a9ae-a08b7ea838fb.png)

第一阶段是冷启动，一开始要收集少量的Long-CoT数据来微调模型，目的是防止早期训练不稳定和可读性差问题。

第二阶段是推理导向的强化学习，它以DeepSeek-V3为基础，针对推理密集型任务，用和R1-Zero相同的大规模RL来进行训练。同时它为了解决语言混杂问题，引入了语言一致性奖励。

第三阶段是拒绝抽样和监督微调，要真正训练R1了，所以它将第一阶段的模型加上一些抽样，结合其他领域的SFT数据，增强模型在写作、角色扮演和其他通用任务中的能力。

第四阶段是适用于所有场景的强化学习，数据准备好、进行微调之后，再以DeepSeek-V3为基础，先是SFT，然后进行所有场景的RL。对于推理任务就用基于规则的奖励来指导，对于一般任务就用RLHF（人类反馈强化学习）这种方式来进行。

这基本上就是R1的技术路线。我简单列一些关于DeepSeek R1的思考和启发：

1、R1/R1-zero的技术路线和社区对o1复现的差异

- 此前社区对o1的复现基本都会涉及到蒸馏和搜索。
- R1-Zero没有SFT，没有过程监督，没有搜索，也能训练出类似o1的效果。学术界之前也有很多实验，但在较小的模型上都没有成功。说明只有基模型足够强，Scaling RL才能取得比较好的效果。
- 虽然R1强调MCTS没有效果，但是简单的majority vote能大幅提升R1的效果，说明搜索仍然是重要的Scale的范式。
- R1的成功还依赖DeepSeek强大的系统效率和RL调教能力。

2、策略初始化

- R1-zero是一个比较好的尝试，但是R1还是经过了先SFT（大概几干条）后再进行RL。
- 未来后训练的重心会逐步倾向于RL，但是少量训练用于SFT可能还是必须的。

3、奖励模型

- R1的奖励设计跟普通的后训练没特别大的区别（Qwen2，Tulu3），有ground truth用ground truth做EM，否则用RM。
- RM的（训练数据量，模型大小，OOD问题，选代周期）的相关问题在整个训练的流程中还是比较关键。可能使用当前开源的比较强大的RM可以达到比较好的效果，也有可能基于内部的数据重新进行了偏好标注。
- 奖励设计（例如RPM的技巧）可能会在基于少量样本的强化学习微调上仍然起到显著作用。

4、PRM和MCIS

- DS给了两个PRM和MCTS的“不成功尝试”。但PRM部分说的比较笼统，并且DS的PRM只评估Correctness（与OAI的Lets verify step by step一致）。
- R1给的是一个简单而且可规模化的可行解，这样做不一定是最优的。基于R1的Test-time search也继续优化它的效果。
- PRM总归是一种比较稠密的监督信号，按照传统R1的理论，对OR进行shaping可以使训练更稳定或收敛得更快。
- PRM不应该是一个被完全放弃的东西，可以让模型收敛得更快速或更稳定（Scaling曲线的斜率更大）。

5、写作能力提升

- o1相比4o在写作等任务上的提升非常小，但R1的创作经常会令人眼前一亮，可能主要是强基模型在Scale RL后涌现的能力，也有人猜测是因为R1的安全对齐做的比较少，没有太约束模型的创作能力。

6、过度优化问题

- R1经常会使用一些高端词汇，典型的如量子纠缠和熵增熵减（会用在各个领域）。猜测是某种形式的reward hacking导致的。
- R1在一些通用领域没有ground truth的任务上的推理效果还并不理想，强化学习的训练并不能保证泛化。

7、Test-Time Scaling

- o1出来后大家讨论比较多的是Test-Time Scaling，但重要的还是Training-Time Scaling，包括数据和Training Step。蒸馏见效快，但上限不高，重要的还是高质量致据的缺失，蒸馏数据无法提供训练Scaling。RL是其中的关键，因为它可以保障有足够的数据和足够的训练步骤。

8、Agentic展望

- R1是目前唯一同时具有强推理能力和联网搜索的产品，效果很好，可以调研一些复杂的信息并进行回答。强推理模型最终的落脚点大概率是Agent，怎么用强推理模型帮助Agent更好更鲁棒是一个比较重要的问题。

## 02 刘知远：R1训练流程有两大亮点，DeepSeek的意义更像Llama

我将从宏观角度来介绍DeepSeek R1所代表的大规模强化学习技术及其基本原理，同时我们也会探讨为什么R1和o1能够引起这么多的关注，并从DeepSeek最近发布的模型，对大模型技术未来发展进行大致研判。

首先来看DeepSeek最近发布的R1模型，它的价值主要体现在能够复现OpenAI o1的深度推理能力。因为OpenAI o1本身并没有提供任何关于它是如何实现的细节，相当于o1引爆了一个原子弹，但没有告诉大家秘方。我们需要能够从头自己去寻找到底如何能够复现出这个能力。

DeepSeek可能是全球第一个能够通过纯强化学习技术复现OpenAI o1能力的团队，并开源和发布相对详细技术介绍，为行业做出了重要贡献。

我们大致可以总结DeepSeek-R1的训练流程，有两个非常重要的亮点。

一是R1模型创造性地基于DeepSeek-V1的基座模型，通过大规模强化学习技术，得到一个纯粹通过强化学习来增强的强推理模型，也就是R1-Zero。这具有非常重要的价值。因为在历史上，几乎没有团队能够成功地把强化学习技术非常好地用在一个大规模模型上，并实现大规模的训练。

DeepSeek之所以能够实现大规模强化学习，一个重要技术特点是采用了基于规则的方法，确保强化学习可规模化，实现面向强化学习的Scaling。

![img](https://pic.yupi.icu/yuyi/1739504015541-d09a0487-413f-4c59-847c-fd3e41971da6.png)

第二个贡献是强化学习技术不只局限在基于规则的数学、算法代码等容易提供奖励的领域，它还可以创造性地把强化学习所带来的强推理能力，泛化到其他领域。这也是所有用户在实际使用DeepSeek R1进行写作等任务时，能够感受到它有非常强的深度思考能力的原因。

那具体是怎么做的呢？它分了两个阶段：第一阶段还是基于V3基座模型，通过增强推理过程的可读性，能够生成相当于是深度推理的SFT数据；第二阶段，它又去结合传统的通用SFT数据来微调大模型，再进一步进行强化学习，从而得到了一个具有非常强泛化能力的强推理模型，也就是R1。

所以DeepSeek-R1的重要贡献体现在两个方面：一是通过规则驱动的方法实现了大规模强化学习；二是通过深度推理SFT数据和通用SFT数据的混合微调，实现了推理能力的跨任务泛化。

我们应该非常重视DeepSeek-R1。它由于开源，让全球的人能够意识到深度思考的能力，相当于让人工智能再次迎来了类似于2023年初的“ChatGPT时刻”，让每个人感受到大模型的能力又往前迈进了一大步。

但是我们同时也要合理评估DeepSeek-R1本身的重要意义。如果说2023年初OpenAI发布的ChatGPT让全球看到了大模型的重要价值，那么这一次的强推理能力，其实也是OpenAI在2024年9月份发布的o1率先在全球实现。

我们认为DeepSeek-R1在历史上应该是更像是2023年的Meta Llama。它通过开源复现，并且把这些事情公开给全球，让大家能够快速建立起相关能力。这是我们需要对DeepSeek-R1重要意义的一个准确认识。

当然为什么说DeepSeek-R1能够取得如此全球性的成功呢？我们认为它跟OpenAI采用的错误决策有非常大的关系。我们会看到OpenAI在发布了o1之后，第一，不开源；第二，把o1深度思考过程隐藏起来；第三，o1收费非常高，不能在全球让尽可能多的人去普惠、去感受深度思考所带来的震撼。

而DeepSeek R1相当于是像2023年初的OpenAI ChatGPT一样，让所有人真正地感受到了震撼。这是DeepSeek R1出圈的非常重要的原因。

![img](https://pic.yupi.icu/yuyi/1739504015872-0c7e752d-9d21-4435-ad60-feac9d37b4f3.png)

如果再进一步，把DeepSeek R1和前面发布的V3一起来考虑，它的重要意义在于，在有限算力资源支持下，通过强大的算法创新模式，突破了算力的“卡脖子”限制，让我们看到即使是在非常有限的算力下，我们仍然可以做出具有全球意义的这一些领先成果，这件事情对于我们中国AI的发展具有非常重要的意义。

同时我们也应该看到如果想要AI能够真正赋能全人类，让每个人都能够用得上、用得起大模型和通用人工智能，高效是一个非常重要的命题。强化学习需要有一些未来更加高效的方案。我们还需要探索出更加高效的模型架构，譬如说V3所采用的MoE架构。未来应该也有很多其他相关方案，还有高效算力利用等等。

这是DeepSeek V3和R1带给我们的另一个非常重要的启示。我们认为，整个人工智能的发展，未来追求高效是我们的一个内在使命和需求。

前一个科技革命，即信息革命，它的一个非常重要的内核是计算芯片的发展。过去80年，计算机从最初要一个屋子才能装得下的规模，发展到现在人手一台的手机、PC、各种各样的计算设备，都具备非常强大的计算能力。所有这一切都来源于芯片行业在摩尔定律的指引下，不断提升芯片制程，提升芯片的电路密度，实现计算设备的小型化、普惠化，推动算力普及。

这也是为什么我们在去年特别强调要发展大模型的能力密度。过去几年，我们看到类似于摩尔定律这样，大模型能力密度呈现指数级增强。从2023年以来，大模型的能力密度大概是按每100天翻1倍。也就是每过100天，只需要一半的算力、一半的参数，就可以实现相同的能力。

![img](https://pic.yupi.icu/yuyi/1739504016364-6eeb38ba-7bf0-4b45-bfa7-d90907aa13b8.png)

面向未来，我们应该不断追求更高的能力密度，努力以更低成本，包括训练成本、计算成本，来实现大模型的高效发展。

上一个科技革命，也就是信息革命，对于我们即将到来的智能革命有非常重要的启示。在信息革命刚刚开始的时候，IBM创始人沃森曾经认为这个世界上不需要超过5台的主机，足以满足全世界的计算需求。但到了今天，全球有数十亿、上百亿的计算设备在服务全人类的社会。

我们认为智能革命也要走过一条类似于信息革命的阶段，也要能够不断提高能力密度，不断降低计算成本，让大模型得以更加普惠。AI时代的核心引擎包括电力、算力、现在所训练的大模型代表的智力。这种密度定律应该是普遍存在的，将是实现人工智能高质量、可持续发展的关键。

面向未来，我们认为人工智能有三大主战场，目标都是要让通用进行到底。

一是人工智能科学化，为能力涌现等关键机制建立科学理论，科学解释人工智能形成的原理。

二是计算系统智能化，大模型与底层芯片、操作系统、数据管理、编程开发、网络通信深度融合，能够在计算层面，用更低成本来把大模型更加通用地用在各个领域。

三是领域应用广谱化，将大模型应用于高精尖制造、科学发现等高度专业化场景中。

最后我特别想说，DeepSeek给我们带来的一个非常重要的启示，就是我们用小米加步枪，依然能够取得非常广阔的胜利。我们即将迎来一个非常重要且意义深远的智能革命时代，它的高潮即将到来，这是可望也可及的。

特别希望能够跟由DeepSeek来吸引来的更多关注这个方向的人，一起沿着正确的发展方向，不只是为算力，更要重视算法创新，重视高水平人才的培养，走出一条真正属于人工智能的高质量发展路线。

## 03 翟季冬：DeepSeek如何降低成本？拆解并行训练策略

我主要分享DeepSeek在系统软件方面的一些工作。这是DeepSeek-V3在技术报告里公开的预训练成本。按照H800 GPU每小时每卡2美元的租赁成本，全部训练成本是550万美元左右，不包括前期探索模型架构、消融实验等开销。

![img](https://pic.yupi.icu/yuyi/1739504016938-4c84c244-05bd-4aa0-a0aa-a26dfa93df94.png)

它的成本相对比较低。虽然我们不知道国外像OpenAI这些公司的模型训练成本，但是可以通过一些相关报道知道成本肯定很高。

大家经常会讨论说，为什么DeepSeek-V3能用这么低的成本，带来这么惊艳的效果？

我们来看一下DeepSeek采用的一些技术。因为DeepSeek本身并没有公开说用了多少张卡。如果按照它给的数据，是2048张H800的话，大约是需要54天，也就不到两个月。如果是1万张H800，大约是11天可以训练好这个模型。

这是DeepSeek V3的模型参数，是671B。GPT-3的参数是175B，所以它要比GPT-3模型大很多。它是一个MoE的架构，每个token会激活37B参数，大约是5.5%。总共包括61层Transformer。然后它在FFN网络，除了前三层以外，全部替换成MoE。它的MoE架构采用了非常多的细粒度专家，包括1个共享专家和256个路由专家。每个token会激活8个路由专家。

![img](https://pic.yupi.icu/yuyi/1739504016866-52c244a0-3ed0-4a24-8f60-9255374a1c46.png)

论文里给了DeepSeek模型架构图，核心是两块，MLA和MoE。MLA可以进一步降低推理消耗的内存。MoE包括共享专家和大量路由专家。

![img](https://pic.yupi.icu/yuyi/1739504016996-93f811e8-cfe8-4a25-9d82-bd9313bd2654.png)

之前发布的一些MoE模型，比如像Mistral，采用的专家数很少、每个专家很大的架构。但是DeepSeek其实采用的是大量细粒度的专家。

![img](https://pic.yupi.icu/yuyi/1739504017691-b5f4e175-757e-47b8-8866-3b47a5012ba9.png)

DeepSeek并行训练方面，技术报告里有一个轻量级训练框架。下图右边是从网上找的一个示意图。具体训练实验平台没有公布，但从它公开的一些数据，它是一个通过InfiniBand连接起来的GPU集群，然后在每个节点内通过NVLink连接起GPU。GPU之间的带宽是160GB，节点之间的带宽是50GB。这是一个网络拓扑情况。

![img](https://pic.yupi.icu/yuyi/1739504017762-eb9edf49-1259-4dd2-ac2f-17826d020c67.png)

它具体采用的并行训练策略，用的是16路流水线并行、64路专家并行，跨8个物理节点，数据并行采用的是ZeRO-1，没有用通信开销比较大的张量并行。我总结了一下，让整个训练效率提升有4个方面的优化，分别是负载均衡、通信优化、内存优化、计算优化。

下面分别介绍这四点。

首先是负载均衡优化。如果要用MoE架构去训练一个超大的模型，最大挑战是负载均衡。我们清华跟北京智源还有一些单位合作训练的八卦炉模型就是一个MoE的架构。

DeepSeek团队为了解决负载均衡的挑战，创新提出了一个叫Auxiliary-Loss-Free Load Balancing的策略，下图是DeepSeek团队公布的一张图片，核心是说当给一个token在计算它录到哪个专家的时候，会给它加上一个专家Bias。Bias的核心目的是保证这些专家负载均衡，如果能做到，最后可以提高整个集群的效率。

![img](https://pic.yupi.icu/yuyi/1739504018158-2a5a143d-d890-4a63-a2ca-f85ced7b378f.png)

它之前有一篇论文是2024年8月份，Bias的核心是只影响专家路由，但是不产生任何梯度影响。然后它会动态调整Bias。调整策略思路比较简单：如果发现某个专家是overloaded，就会降低这个Bias；如果发现某个专家给他的负载不够，它就会增大Bias。核心是要控制，让这些专家能够均衡。如果控制不好专家负载均衡，那它在一个大规模集群训练时，利用率很难提升上去。

第二，它们的工作用了很多通信优化。用专家并行会引入非常大的All to All通信开销。为了降低这个通信开销，它想了很多办法。

它提出来一个DualPipe算法，核心是精细地编排计算和通信。这里有两张图，下面是它的技术包里的图片，上面是我从网上找到的。可以看到这是两个micro-batch，前向跟反向可以拆分成一些单元，比如计算attention、计算MLP。All to All有两个阶段：一是把token分发，最后在过完专家之后，会把它收回来，叫combine。这样前向和反向都有一些计算和通信。它通过精细控制GPU SM数量，保证计算和通信正好能够完全重叠。

![img](https://pic.yupi.icu/yuyi/1739504018203-6546439b-3e40-4fe5-843a-80c9a05c632c.png)

具体怎么重叠呢？它采用的是双向流水线机制。下图上方的示意图用的是一个8级流水线、20个micro-batch，从前向和反向两条流水分别去流，然后在中间稳定状态，黄色跟绿色部分就是前项跟反向重叠的阶段。也就是说在这个过程中，可以让计算和通信充分重叠。它也给了一些分析。

![img](https://pic.yupi.icu/yuyi/1739504018414-f10bbb65-d022-457d-9bd4-39c4d4e19408.png)

这里有一个需要注意的点，如果采用双向流水线，要在GPU显存里存两份模型参数。大模型训练内存使用非常重要。为了解决这个问题，它采用了64路的专家并行。双流水可以非常有效地降低流水线的bubble。

下一个是，通信优化一定会有一些token会被路由到，相当于是走IB网络会分到其他物理节点。它采用了一个算法，这个code design会限制跨节点的token，每个token最多可以路由到4个物理节点。这实际上是在算法层面的一个调整。

同时它在节点内每个token最多平均可以选择3.2个专家。为什么是3.2个专家呢？这里的核心IB带宽是50GB/s，NVLink带宽是160GB/s，相差的比值是3.2。也就是说在一个节点内路由3.2个专家和在IB上路由1个专家的时间是相当。这样就可以保证IB和NVLink传输时间是重叠的。

![img](https://pic.yupi.icu/yuyi/1739504019574-ab305723-9046-4337-b737-b007a1e2fd94.png)

同时它还有一些token的路由策略。它用到一个确定性的路由策略，可以非常简单高效。它首先通过IB转发到确定的节点，再通过NVLink转到对应的GPU上，还采用了warpspecialization技术。H800里有132个SM，这里是用20个SM来控制通信，用剩下的SM做计算。这20个控制通信的SM，同时还会去动态调整web的数量，会根据通信负载，通过英伟达提供的底层PTX（类似于像汇编层的编程语言），来控制SM使用。

下面介绍内存优化。大模型训练中内存非常重要。DeepSeek团队在优化内存方面想了非常多的办法。比如重计算，提出相应方法，把一些前向计算不去存，反向时再去计算，这样可以节约一些内存使用。同时它还把一些数据，包括像模型参数的指数移动平均，存到CPU内存，这样也是节约GPU显存。

![img](https://pic.yupi.icu/yuyi/1739504019418-7a501545-6082-4d8f-853f-8c53d5c9ed80.png)

它还有一个机制，就是为了提高模型精度，采用MTP。它把主模型和MTP模块的outputhead和embedding部署在相同节点，让参数共享。核心是想办法去降低内存。DeepSeek团队没有公布用了多少个节点去做模型训练。对于给定的算力，GPU显存是一个非常珍贵的资源。

另外它为了提升训练的效率，采用了混合精度。它用了英伟达最新FP8，把主要计算量、比较大的核心矩阵乘法都用FP8去计算。但是用这些低精度去做训练，模型可能不收敛，或者导致不管是activation还是weight会有一些outlier的存在。

DeepSeek团队为了减缓outlier影响想了很多办法，比如采用了细粒度量化，对于activation采用tail条形分组量化方式，对于weight采用block分组方式。同时它还通过增加累积精度（FP32）、增加尾数量，以及在线量化策略。这些方式都是为了减缓outlier的影响，来提高模型精度。最后它用FP8低精度达到了模型收敛。

![img](https://pic.yupi.icu/yuyi/1739504019581-63ec92c7-d4d7-47fd-8ee1-439ddfcf7724.png)

总结一下我对DeepSeek的一些思考：

第一，协同创新，DeepSeek团队充分挖掘了算法、软件、硬件协同创新。比如它采用了MoE架构，但又在算法和软件层面上解决了MoE本身专家并行带来的通信开销问题。

第二，软件灵活，如果大家看DeepSeek论文分享报告，能看到软件是非常灵活的。当我们用某一款硬件，不管是英伟达的还是某一款芯片，它都会有一些限制。这个时候软件能够弥补硬件的很多限制。

第三，系统软件，DeepSeek团队为了降低模型训练成本想了很多的办法。优秀的系统软件可以充分释放底层硬件的潜力，极致优化。包括DeepSeek团队自己也承认，用了很多非常细致的优化。这些也是它通过挖掘一点点的优化，让整个模型的训练效率提升，来降低训练成本。

最后从我个人角度来说，DeepSeek把整个模型开源，能极大促进人工智能领域的飞速发展。有一个非常开源好用的、效果非常好的大模型，我们就可以尝试更多软件相关优化。

## 04 戴国浩：PTX是否做到绕过CUDA垄断？如何极致优化大模型性能？

我来就DeepSeek在软硬件上的优化，特别是绕过CUDA层的事情上，展开做一个讨论。

我关注DeepSeek团队和他们的工作有很长一段时间了。他们论文发布时，我非常喜欢这份技术报告。把它的目录做个拆解，可以看到它基本上在文章中说了四件事，分别是模型架构、系统架构、预训练方法、后训练方法。相对于模型架构、预训练和后训练，团队对于系统架构做了非常充分的介绍。

![img](https://pic.yupi.icu/yuyi/1739504019627-02a906b6-acff-43d9-93f9-05c3938dd98d.png)

我在思考的事情是：为什么这样一个大模型的工作，大家会花更多的时间和精力去介绍系统层的架构？

DeepSeek团队有大量的工程师是聚焦在系统架构的优化上。过年期间我刷到了很多（DeepSeek绕开CUDA）的推送和新闻。我相信它最早的来源是来自于DeepSeek论文中这样一句话：

“we employ customized PTX（Parallel Thread Execution）instructions and auto-tune the  communication chunk size, which significantly reduces the use of the L2 cache and the interference to other SMs。”

“我们采用定制的PTX（并行线程执行）指令并自动调整通信块大小，这大大减少了L2缓存的使用和对其他SM的干扰。”

可以看到通过这样的一个定制的PTX优化，使DeepSeek的系统和模型可以更好释放底层硬件的性能。无论是在通过去做一些auto-tuning，或者说去做一些communication chunk size的调整。它对于L2 cache的使用，以及不同SM之间的streaming multiprocessor之间的干扰，都会做到最小。但是这些被媒体们解读成，国外可能叫“breakthrough by pass CUDA”，一些国内媒体会解读成是“绕开CUDA垄断”。

我们具体来看一下，到底什么是CUDA，什么是PTX？为什么绕开CUDA的垄断这件事在我们看来具有很重要的价值，以及它是否真的做到了绕开CUDA的垄断？

稍微给大家介绍一下，大家平时在使用GPU或者英伟达硬件时，编程时到底是怎么一步一步来调用到底层硬件的？为了做深度学习，为了训练一个大模型，首先你需要有一张或很多GPU卡。但在上面做编程时，一般大家更多接触到的是像PyTorch或者Python这样的高层语言。一个很高层的语言最终是怎么调用到底层硬件的？它实际上经过了很多语言转换和编译的过程。

这是我上课时会用到的一页PPT。一般上层的应用会通过一些高层次的语言，或者说硬件的一些接口，从而进行编程，于是大家并不需要关注到底层硬件长得是什么样子。这些接口包括了像CUDA，也就是英伟达所提供的硬件接口，也有一些其他的，大家如果做一些图形和图像显示，会用到像DriectX或者并行计算会用到OpenCL等接口。

![img](https://pic.yupi.icu/yuyi/1739504019869-9ae428b6-33e7-4a47-afff-05814292c3ef.png)

有底层CUDA的driver（驱动），通过驱动最终来调用到底层硬件。可以看到CUDA是一个相对更上层的接口，提供了面向用户的一系列编程接口。而PTX一般被隐藏在了CUDA的驱动中，所以几乎所有的深度学习或大模型算法工程师是不会接触到这一层。

那为什么这一层会很重要呢？原因是在于可以看到从这个身位上，PTX是直接和底层的硬件去发生交互的，能够实现对底层硬件更好的编程和调用。

右边我们举了一个Triton的例子，也是OpenAI在主推的一个跨平台编程语言。它也是通过不断地编译和语言的转化，最终在调用底层英伟达硬件的时候，通过PTX code来调用的。所以简单来说，PTX的这一层是通过和硬件的直接交互，使得可以控制硬件更多的细节。

这件事为什么重要呢？我认为它一共有两大类优化。

第一大类优化是底层优化。给定某一个确定性的算法、模型以及底层硬件，通过优化软件，比如做一些通信优化或者内存优化，这些是不改变任何程序执行的正确结果的。

另一大类优化是协同优化。像混合精度的量化、MLA这些，同时优化算法、模型、软件甚至是底层硬件。这就使得整体系统的优化空间变得更大。

首先来看一下，为什么在底层做PTX优化？举一个冒泡排序算法的例子，我们分别用C代码和Python代码来做实现。一个小的彩蛋是这里的代码我都是拿DeepSeek来做生成的。C代码相对更复杂，在实际编程时要关注到一些底层硬件细节，比如数组存储位置。但Python语言相对更简单，不需要去关注底层硬件细节。

![img](https://pic.yupi.icu/yuyi/1739504020784-f12894f8-2e98-454c-ae35-9b4e94ebbe87.png)

为什么还是有很多工程师需要去聚焦一些像C代码的开发呢？我们用了另一篇论文中的实测数据，可以看到越接近底层的语言，对于整体硬件的利用效率更好。在底层做更多的优化，就更好地挖掘系统性能来做。

而PTX层相对于C或者说CUDA层会更偏底层。我们通过在这一层的优化和编程，就可以更好释放底层硬件的性能。

举一个典型的底层优化例子，像Flash Attention这样的工作，它将整个GPU和CPU整套系统的Memory来做划分，分别是寄存器级别的SRAM以及GPU上的HBM，包括CPU端的Memory。通过对于不同层级的Memory的精细控制，Flash Attention所实现的Attention算子，大家可以理解成是一个函数，相对于PyTorch原有实现可以快出将近一个数量级。这样的优化工作被证明可以广泛应用在大模型训练中。

我们之前的一个大模型推理工作FlashDecoding++，也是通过对于底层硬件的不断优化和感知，使大模型推理速度进一步提升。这只是一个科研性的工作，我们更想强调系统优化工作是可以被应用到更多底层芯片中的。我们大概这里有1/3的国产芯片，都可以通过这样感知到底层硬件的优化途径，进一步释放底层硬件的性能。这种优化性能甚至可以达到3倍以上。这就是底层优化对于整个大模型系统的意义。

说完底层优化，另一件事就是协同优化。

什么叫做协同优化呢？底层优化说白了就是在CUDA或者CUDA下面这一层来做优化。整个大模型的生态系统，从最顶层的产品应用到底层的基础设施，每一个层级都已经形成了非常好的生态，但每一个层级上都存在着非常好的优化空间。所以是否有可能在每一个层级上都达到一定的优化，最终形成一个笛卡尔积，实现更高的整体优化性能？这是我们在思考的第二个大方向，也是我们在DeepSeek论文中看到的一个很大的方向。

![img](https://pic.yupi.icu/yuyi/1739504020956-666c1d07-0bd9-4033-bc65-43023925fe39.png)

这里我们同样举了两个例子。

一个例子是可能在半年到一年前非常火的一家芯片公司Groq。它通过定制化的硬件架构，将传统GPU中的HBM内存去换成了一些节点的SRAM内存，可以实现相对于英伟达GPU呈数量级的大模型推理速度的提升。

我们自己也做了一些相应的硬件和芯片工作，可以相对于GPU，进一步提升大模型在一些多模态任务上的推理速度。这就告诉我们的一个很重要的结论，通过软件+硬件协同优化，可能进一步甚至是超越GPU的性能。

在调研性工作中，我们系统性阐释了通过量化、稀疏化以及一些快速解码。包括一些算子，甚至是一些定制化的硬件架构，如何通过协同优化的方式，把大语言模型推理和训练速度进一步释放和提升，从而满足我们所畅想的未来广泛智能场景的一些应用。

人工智能的发展得益于三驾马车，算力、算法和数据。每一波浪潮人工智能的发展速度都与这三者息息相关。第一波人工智能浪潮止步于算法的缺陷，第二波浪潮止于算力突破。第三波浪潮得益于算法和算力都得到了空前的发展，大数据成为了另一块基石。那数据如何进一步发展？强化学习、多模态数据的获取，都可能成为助推力。

所以可以看到这样的一个人工智能发展过程中的闭环，也是我们进一步思考的事情。这个闭环如何在国内实现？我们把这样的一个逻辑图给画出来了。

![img](https://pic.yupi.icu/yuyi/1739504021117-facf730d-956b-4413-925a-a4424c3981f4.png)

在国外，模型、芯片、系统已经形成了一套非常完备的闭环生态。在国内，DeepSeek做了非常好的一环，就是使国内模型超越了国外模型，或者说在某些场景完成了超越，或者说在方法论层面上完成了超越。但是如何形成国内“模型-系统-芯片”闭环呢？这是我们认为在未来一定会发生的事情。

DeepSeek打响了非常好的第一枪。我们也希望能够通过国内系统和芯片的闭环发展，使它达到这样的一个结果。为了实现这件事，我们有非常好的基础设施和上层的应用。但是在中间软件和硬件的一些协同优化，是我们需要在未来不断努力和提升的。

最后做一个总结，我们从PTX和CUDA层的优化思考到未来对大模型性能的极致优化，可以分为在CUDA层、PTX层的底层优化，以及打通软件硬件的协同优化，最终实现模型系统和芯片的闭环，以及“软件到硬件”+“硬件到软件”的闭环。

## 05 Q&A：从DeepSeek的轰动成功中我们能学到什么？

问题1：请从各自的专业角度来分享和解释一下，目前DeepSeek引起的一些效应，其中最有亮点的技术是什么？

邱锡鹏：它最出圈的可能还是因为效果好。很多o1的复现模型可能在某些指标上比较高，但实际用起来会觉得并没有做到真正的推理技能。但是R1确确实实达到了o1的效果，在很多方面的表现令人惊艳。o1对标R1，相当于ChatGPT对标Llama。开源非常重要，如果它是个闭源模型，那么一定不会像现在这么出圈。

还有一个令人震惊的是R1-Zero，证明了如果采用纯RL，就能够让模型自己涌现长CoT能力。很多时候大家复现o1，非常重要的是训练数据从哪里来。如果通过纯RL就能够增强长推理能力，就让人产生非常大的遐想：我们是不是将来有很大的机会，可以通过大规模的强化学习训练，在推理路线上达到或超过o1，并且在很多其他领域也能够达到像在数学等强推理领域的效果？所以我觉得它确确实实打开了一个思路。

最后一点是在模型上，它没有通过过程监督、MCTS、搜索，类似于用非常简单的方法，就能通过Scale达到如此好的效果，这也是非常令人惊讶的。

刘知远：我觉得有两个。一是由V3带来的启示，它展示了用1/10甚至更少的成本，完成了大概达到GPT-4和GPT-4o水平的能力。V3在底层算力加速方面做了大量工作，实现算法和底层软硬件的协同优化。这种一体化优化机制，让大家看到即使成本已经很低，仍然可以通过优化进一步降低成本。虽然V3的成本仍然是几百万美元甚至几千万美元，但相比国际上公认的水平，已经低得多。这也是英伟达股价会下降的一个重要原因。

第二个是R1给我们的启示。因为OpenAI犯了傲慢之罪，不开源，不公开技术细节，价格又非常高，所以不出圈。在这种情况下，R1开源又免费，让全球用户使用，而且公开了所有技术细节。相当于是把原来应该由OpenAI占有的像当年ChatGPT的身位，让给了DeepSeek。

DeepSeek通过极致优化有限资源，成功追赶上国际最先进模型，我觉得干得非常漂亮。而且通过开源，让全球都认识到我们中国团队的创新能力。

翟季冬：我印象最深的是DeepSeek的架构创新，尤其是MoE。我们团队最早从2021年开始做MoE。当时我们实验室有同学做Fast-MoE框架，在2021年开源。这个方向当时用的人很少。

MoE有优点也有缺点。优点是模型参数增大，也不显著增加算力。但真正训练起来会有很多问题，包括负载不均衡，包括如果训练像稠密模型在英伟达平台可能我优化到40%到50%的效率，但实际上训练MoE很多时候只能优化到10%或20%，可能会更低。针对这个问题，很多做模型的可能就会放弃。

国外像Mistral架构，采用的是专家数很少、非常均衡的策略。DeepSeek团队比较敢于创新，设计了每一层有256个路由专家、1个共享专家。之前的研究有Auxiliary Loss的算法，会使梯度发生扰动，影响模型收敛。DeepSeek提出来Loss Free方式，既能让模型有效收敛，同时解决负载均衡。

我觉得不完全追随国外的策略、有自己的思考，非常重要。中国发展到这个程度，我们一定要有一些自己的思考、判断。不能说别人这样做，我们就一定这样做。

戴国浩：我从两个方面来讲。首先从学术角度来看。过去两个月内很多团队、厂商都发布了自己的模型，并且对于自己模型架构都提到了非常多的新设计。这是我们看到非常欣喜的一件事情，使我们有更多的机会可以通过底层优化去助力上层模型的发展。

如果模型架构本身没有特别大的变化，像Flash Attention这样的一些技术可以完全优化各个模型。但实际上由于模型不断变化，我印象非常深的是在DeepSeek里MLA这样的架构。这使得我们必须得通过底层的系统优化，而不是去用一些现成框架就能达到非常好的性能。

第二件事情是我看到的一个机会。以往我们进行优化管理时，都会设定一个优化目标。原来可能只是关注算法精度，后来发展到软硬件协同优化，又会把硬件的一些约束放在里面。我们现在还必须面临的一件事情是算力不足、资源受限的情况。这个优化问题的解在我看来目前DeepSeek给了一个非常好的答案。

通过更低成本的训练，我们可以获得一个更好的模型。也就使得我们形成一个“模型+软件+系统+芯片”的国产闭环，在未来都发生成为了一个非常大的可能。所以这件事也给了我非常大的信心。

所以这从学术和产业的两个角度，都给到了我非常大的惊喜。

问题2：为什么是这个时间点出现了R1模型？之前没有基于基模型直接做强化学习的尝试吗？在这个时间点上，为什么是DeepSeek做得如此之出圈？

邱锡鹏：我觉得他们是一个长期积累的结果。比如V2版当时已经引起大家对他们能力的认可，然后是V3，直到R1的出现，不是说突然爆冷。它从去年5月份就已经开始就部署整个团队，一直在往这方面迭代研究，所以我觉得是在大模型这条路线上，加一些AGI的信念，加上软硬件协同创新能力，一步步走到今天。

它在今年出圈爆火，确确实实是真正能够从底层优化和创新上，对国外OpenAI或者Meta这些大公司产生一些震撼。我们国内虽然受到非常多的算力封锁，加上训练资源限制，但是依然能非常出色或高质量地做出性能如此好的模型，确实是他们出圈的根本原因。

刘知远：我觉得这件事有一定的必然性。大概2024年时，很多投资人，甚至一些不从事人工智能领域的人，问中国的AI跟美国的AI相比，到底差距是变大还是变小了？我当时明确说，我们认为中国正在非常快速地追赶，与美国最先进技术之间的差距正在逐渐缩小。

虽然我们被“卡脖子”，有这样那样的一些限制，但一个很重要的现象可以验证这一点，国内复现ChatGPT、GPT-4模型大概需要一年时间，再往后看，像Sora、GPT-4o，国内团队可以在半年左右完成相关复现工作。

像o1这样的模型能力，DeepSeek非常大的价值是它不只能够复现，而且用了非常低的成本。能够在半年左右复现o1水平模型的能力，这件事情应该对于我们国内一线团队来讲是可预期的。只是说DeepSeek能够更快，而且是更加低的成本，高效完成工作。由DeepSeek来达到这么出圈的效果，有团队本身的必然性。

邱锡鹏：我再稍微补充一下，ChatGPT的复现，因为之前还有一些相关的论文发表，所以技术路线相比o1更清晰。但o1确实是OpenAI几乎没有任何的论文或技术报告的发表，所以大家都是猜测，难度会高很多。

问题3：我们今天看到的DeepSeek技术的爆发，对于中国大模型的未来高质量发展道路会有哪些启示？

邱锡鹏：DeepSeek团队应该大部分都是刚毕业的硕博士，还有很多高年级实习生，能够非常好地支持长期的基础创新。我也看了梁文锋（DeepSeek创始人）的一些采访，他认为AI或者大模型还没有到非常大的商业变现时刻，所以目前阶段还是以基础创新为主。在此阶段有一个非常好的高人才密度团队加敢于创新，是非常重要的。

现在毕竟还是有o1明珠在前，我们在追随。下一步如果真正做前沿创新，需要更大的对未来探索性的东西或尝试，不怕失败。科研环境还是非常重要的。

刘知远：我说两点。第一点，我特别敬佩整个DeepSeek团队的技术理想主义，以实现AGI作为梦想去组建团队。同时看到梁文锋之前是做量化投资，自己投钱来做这件事情，没有资金上的相关困扰。对应的，我觉得中国应该要给这样的技术理想主义提供支持，哪怕不像DeepSeek这么有资金，能否也能让他们没有后顾之忧地进行探索、踏踏实实地做一些原始创新？

第二点，是他们的执行力。DeepSeek这两个月一炮而红，是经过多年的持续积累，量变产生了质变。我可以告诉大家，几年前，DeepSeek就是幻方，当时拿着免费算力来诱惑我们的学生，与他们建立联系。也有学生毕业后加入了DeepSeek。

我觉得这也是技术理想主义推动下的长期主义成果。国内应该有更多的团队，能够坐得住冷板凳，更加聚焦，在一些重要问题上持续发力，做出有意义的工作。

DeepSeek发展到今天，它做的所有工作可能也是在摸着OpenAI过河。相当于它以OpenAI为师，来看AGI到底该怎么实现，然后努力做他们认为OpenAI做对的事情。的确这个过程非常困难，包括随着OpenAI变得越来越封闭，o1如何复现会比当年复现ChatGPT更加困难。但我们看到只要有理想和执行力，它就可以做到。

国内应该有更多的团队去学习。具体技术当然是我们应该学的一部分，但是要避免会认为因为DeepSeek成功了，所以它做的所有的事情都是对的。它所有的技术是不是都是最先进的？我觉得不见得，这样反而会限制我们的创新。我们应该学习的是它的理想、坚持、方法论。

翟季冬：DeepSeek对我最大的启发有两点。第一点是创新，创新是社会进步和个人发展的永恒动力。DeepSeek团队在这个过程中，比如说为了降低算力成本，为了突破模型推理精度，想了很多很多创新的办法。未来一定要勇于创新，才能发现更多的机会。这一波人工智能让我们最兴奋的是每隔可能一两年，就会让我们看到很多新的东西。

第二点，从我个人的体会来说，我觉得DeepSeek榜样的力量非常重要。我们高性能计算领域，有一个非常重要的奖项叫戈登贝尔奖。这个奖项其实设立了快30年，中国没有拿到奖。我们在计算机大会上也有论坛，当时讨论说中国离戈登贝尔奖还有多远。后来在2016年，由清华跟中科院软件所一起拿到戈登贝尔奖。后来国内陆续多次拿到这个奖。

DeepSeek团队这次能取得这么好的成果，一定会对中国在人工智能领域的工作者，给一个非常好的榜样力量。大家还会做出更多好的成果。我们中国人自己的团队做出这样的成果，我们也有信心继续努力。这可能对中国未来的人工智能发展会至关重要。

戴国浩：我主要说三点。首先是对于个人或者团队，我非常钦佩DeepSeek团队。他们是一帮能创新、有理想并且很坚持的人。在AI领域，在过去2到3年发展还是非常快的。如何坚定走一条他们认为正确的路，并且持续做创新，这对于个人和团队来说是一个非常大的启示。

第二点是对于整个国内人工智能的发展。当我们有了单点突破之后，未来我们可以预见到，只要我们持续坚持来做这样一件事情，未来一定可以形成一套闭环的生态。我们不仅是在算法，我们在系统、软件、芯片各个层面上，都有可能去做出一些不一样的工作。

我最关注DeepSeek的一个点就在于可以做到大幅度降低训练大模型的成本。人类发展历史上每次工业革命中，一些新的生产工具的诞生，都会使得生产力有大幅度的解放。而生产工具能够提升生产力的本质，是因为生产力成本是不断降低的。随着训练成本降低，未来可以在很多智能终端场景中大幅降低推理成本，助力到人类生产力的进一步解放，推动人类迈向下一个台阶。

06

Q&A：MoE是否是最优解？

长思维链设计对硬件有什么需求？

问题1：每100天大模型能力密度会减少一半。这个能力密度是怎么定义的？内在原因是什么？是模型优化还是数据质量？长思考类模型的参数密度和评估是否和普通大语言模型一致？

刘知远：能力密度是我们最近半年提出的一个概念。如何有效准确衡量，可以去看论文《Densing law of LLMs》。所谓的能力密度，可以理解为模型在各种评测集上所展现出来的能力，除以其参数规模。我们观察过去一年半发布的代表性模型，能力密度每100天会增加一倍，其意义就在于每过100天就可以用一半的参数，实现相同的能力。

这一现象背后有多个因素影响：一是数据质量可能更高，取决于数据治理；二是模型架构，采用更稀疏激活的模型架构，可以用更少的激活参数承载更多能力；三是学习方法，包括OpenAI在内的所有一线团队都会开展的“Scaling Prediction”。在真正训练一个模型之前，我们会进行大量的风洞实验，积累各种预测数据，以确定模型需要什么样的数据配比和超参配置，从而达到最佳效果。

综合这些因素，模型可以用更少的参数，承载更多的能力。我们将这一现象类比芯片行业的摩尔定律。摩尔定律是电路密度不断增加的过程，通过技术发展实现。进一步结合底层算力优化，我们可以将这种优化映射到模型训练阶段，从而极大降低成本。当然，我们并不是说DeepSeek的算力可以用1/10的成本实现与国外模型相同的能力，但这与Densing law（能力密度定律）有一定的重叠。

Densing law更多地强调模型密度不断提高，它不仅体现在训练阶段成本的降低，也体现在推理阶段。模型可以用更低的推理成本、更快的推理速度，完成相同的能力。我们认为，未来AI的发展一定会沿着这条路线前进。过去几年的发展也在不断验证这一点。

一个直观的体验就是，OpenAI等一线公司的API价格在过去几年快速下降。原因不只是在打价格战，而是因为它们可以用更少的资源实现相同的能力，从而让更低的成本去提供服务。

我们认为，高效性是未来AI发展的一个重要方向，也是我们迎来智能革命的一个重要前提。

问题2：基于DeepSeek的这样一个软硬件协同优化的方式，未来国产芯片或者国内芯片加国外芯片的组合，以及CPU+GPU异构组合，对大模型进行优化，会不会成为未来的新兴热点方向？

翟季冬：我觉得一定会的。最近华为也把这个DeepSeek R1移植到昇腾平台。我相信过年期间工程师肯定都没有休息。因为DeepSeek R1模型是开源的，国产芯片都可以尽快尝试把模型移植到自己的芯片。我相信今年上半年这方面的工作会非常的多，肯定有很多相关的公司或工程师在做这个方向。

戴国浩：这是我们一直坚信的事情。在未来或者今年，我们就可以看到很多国内模型会应用在国内场景中，并且底层使用国内芯片。我们自己也在做很多这方面的一些工作。目的是为了告诉大家，用国内芯片去跑国内模型，用在国内应用场景中，是真的可以做的高效并且形成一整套闭环的。

这里有很多的工作需要做，需要整个团队对于从上层软件到底层的芯片都很了解。以DeepSeek为例，它仅仅是对于PTX这一层的优化，就可以带来这么大的性能提升。而国内这么多的芯片、这么多的模型，这样的M乘N打通，具有非常大的价值。我们坚信这件事情在今年和未来的很长的一段时间都会发生。

问题3：MoE架构会是通往AGI路上的最优解吗？

刘知远：我的个人感觉是，没有人永远是对的。OpenAI发布ChatGPT、GPT-4，它做对了；但发布R1，它做错了，没有开源，定价出现了策略失误，所以相当于是成就了DeepSeek。

我也不会认为因为DeepSeek选择了MoE，MoE就永远是正确的。没有任何证据证明MoE是最优的模型架构。从学术的角度和AI未来发展的角度，这是一个开放性的问题。未来如何实现高效性？我认为一定是模块化和稀疏激活的，但具体如何稀疏激活、如何模块化，这件事情本身应该是百花齐放的。应该鼓励学生和从业者像DeepSeek一样去努力探索创新。

所以，我本身不太认为MoE有任何绝对的壁垒，或者它一定是最优的方法。

翟季冬：我虽然不是做模型出身，但是我觉得这一波人工智能对我影响最大的，就是在不停变化。很有可能又有些新的技术会颠覆现在的技术。要对未来充满更多的期待。

戴国浩：没有什么方法是永远正确的，但会有一些方法论是永远正确的。这种开源也好，这样的一些新方法探索。技术发展跟时间有关，例如上世纪80年代很多机器学习会议会拒收神经网论文，因为在当时看来效果不好或者可解释性差。

我们一定会抱着一个非常开放的态度。无论是新的模型架构、新的硬件架构，抑或是一些联合设计的方法，都是在未来探索的方向。MoE现在取得不错的效果，我们认为是当前的一个非常好的解。但未来是什么样子？这需要更多的老师同学、行业内的创业者，大家一起来做探索。

邱锡鹏：MoE是大规模模型在做规模上Scale的和现在GPU架构的一种妥协。未来底层硬件的改变，以及新架构芯片的出现，可能都会使模型发生非常大的变化。一个趋势可能是未来模型架构上面的设计，会更多依赖或考虑到底层硬件上的优化。比如通信带宽，如果有朝一日变得非常高，那么可能架构就会发生不一样的变化。

问题4：长思维链设计对硬件有什么需求？存储能力是否适合当前的推理？长思维链模型设计方面，对于硬件有什么需求？计算和存储能力是否适合现在这类推理？

戴国浩：这是一个非常好的问题，也是我们最近正在做的一些研究课题。举一个例子，原来的这种大模型，以Llama为例，它是一个token一个token来做输出的。但这种长思维链的过程可以分成两个阶段。一个阶段是在每一步一个token一个token输出，但形成了一段话之后，就会有这样一个思维的过程，它其实是一个sequence to sequence输出。

所以我们可以看到两个直观变化。一个变化是它对于历史信息的获取提出了更高要求。另一个是它对于整体推理时间和推理成本的需求，也会变得更大。

我们知道大模型本质上在推理过程中是一个访问受限的问题。那如何去提供更高带宽，使得在长思维链过程中还能保持一个比较高的推理效率？这一点除了在软件上来做优化，底层硬件甚至是硬件本身架构，传统的是计算和存储的分离，是否有可能把计算和存储放的更近，甚至是放到一起？这是我们看到的一个非常大的趋势。相信未来如果说算法本身的发展是往这个趋势来做，也一定会有相应的新硬件架构的出现。

问题5：关于PTX方法的通用性，如果我们换一种模型或者换一种类型的卡，那么重新用这种方法再做，它的泛化性以及工程成本有多高？

翟季冬：PTX是英伟达为了更精细地控制底层的硬件，在CUDA往下的一层。其他硬件厂商也会有一些偏底层的控制指令。因为PTX毕竟是英伟达自己的指令。如果换成其他的芯片，肯定要去用对应的芯片底层相应的一些接口，这肯定是要变的。

戴国浩：我非常同意翟老师的观点。大家不用去神话PTX。特别是学过计算机的这个同学，可能在大学阶段都学过一门课程叫做汇编语言。PTX大家可以理解成就是英伟达GPU的汇编语言。我们把它放到国产GPU上，类似的也会有相应汇编。特别是在目前国产GPU上层软件生态相对英伟达来说没有那么成熟的情况下，使用国产GPU的“PTX”也是一个必然的路径。这里面会涉及到系统软件开发人员和硬件人员的紧密配合。



> 来源：https://finance.sina.com.cn/money/smjj/smdt/2025-02-07/doc-ineisiaa7498981.shtml?utm_source=chatgpt.com